package com.agilex.healthcare.veteranappointment.dataservice;

import java.util.Calendar;
import java.util.Date;

import javax.annotation.Resource;

import org.springframework.stereotype.Component;

import com.agilex.healthcare.veteranappointment.datalayer.careteam.ProviderDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifiers;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientProviders;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import gov.va.vamf.scheduling.direct.datalayer.user.VarPatientCorrelationGateway;

@Component
public class ProviderDataService {
	
    @Resource
    ProviderDataLayer providerDataLayer;
    
    @Resource
	protected VarPatientCorrelationGateway patientCorrelationGateway;
    
	public PatientProviders fetchPrimaryCareProviders(PatientIdentifier patientIdentifier, String siteCode, boolean byFacility){
		PatientIdentifier icnPatientIdentifier = getICNFromEDIPI(patientIdentifier);
		if(icnPatientIdentifier != null){
			PatientProviders providers = providerDataLayer.fetchPrimaryCareProviders(icnPatientIdentifier, siteCode, byFacility);
			return providers;
		}
		return(new PatientProviders());
	}

	public PatientProviders fetchMentalHealthProviders(PatientIdentifier patientIdentifier, String siteCode, boolean byFacility){
		Calendar calendar = Calendar.getInstance();
		calendar.add(Calendar.MONTH, -13);
		Date thirteenMonthsBefore = calendar.getTime();
		DateFilter dateFilter = DateFilterFactory.createFilterFromDate(thirteenMonthsBefore, null);
		PatientIdentifier icnPatientIdentifier = getICNFromEDIPI(patientIdentifier);
		if(icnPatientIdentifier != null){
			PatientProviders providers = providerDataLayer.fetchMentalHealthProviders(icnPatientIdentifier, dateFilter, siteCode, byFacility);
			return providers;
		}
		return(new PatientProviders());
	}
	
	private PatientIdentifier getICNFromEDIPI(PatientIdentifier edipiOrICNPatientIdentifier){
		if(edipiOrICNPatientIdentifier != null && "ICN".equalsIgnoreCase(edipiOrICNPatientIdentifier.getAssigningAuthority())){
			return edipiOrICNPatientIdentifier;
		}
		PatientIdentifiers patientIdentifiers = patientCorrelationGateway.getCorrespondIdentifiers(edipiOrICNPatientIdentifier);
	    if(patientIdentifiers != null && patientIdentifiers.size() > 0){
	        for (PatientIdentifier patientIdentifier : patientIdentifiers){
	            if("ICN".equalsIgnoreCase(patientIdentifier.getAssigningAuthority())){
	                return patientIdentifier;
	            }
	        }
	    }
	    return null;
	}
}